
#ifndef CRYS_HOST_TST_DES
#define CRYS_HOST_TST_DES

/***************************************************************** 
*  @file CRYS_HOST_TST_DES.h
*  @brief Functions used for HOST-SEP communication to send message from HOST to SEP
*         that contains requested API to be executed in SEP and API parameters
*         Used for SEP External application ATP testing.
*
*  @author mottig
*  @remarks Copyright (C) 2004 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "ExtApp_CRYS_Defines.h"
#include "CRYS.h"

#ifdef __cplusplus
extern "C"
{
#endif


/************************ Defines ******************************/

/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************Public Variables **********************/

/*********************** Public Functions **********************/

/****************************************************************************************************/
/* 
 * @brief This function is used as a connectivity HOST-SeP test. It sends a message with 
 *		  one parameter only (counter variable) to the SeP and then gets acknowledge message 
 *		  back from SeP with this parameter (counter variable) increased by one. 
 *
 *        The function executes the following major steps:
 *
 *        1. Build a message with one parameter -this is the counter variable.
 *
 *        2. Sends message to SeP.
 *           
 *        3. Gets response message from SeP
 *        
 *		  4. Checks if the counter variable parameter increased by one.
 *
 *        5. Exit with appropriate error message.
 *
 * @return DxUint32 - On success DX_OK is returned
 */
IMPORT_C DxUint32 SEPQA_DES_NotIntegrated(
                                    CRYS_DES_Iv_t             IV_ptr,                 /* in */ 
									CRYS_DES_Key_t           *Key_ptr,                /* in */ 
									CRYS_DES_NumOfKeys_t      NumOfKeys,              /* in */ 
									CRYS_DES_EncryptMode_t    EncryptDecryptFlag,     /* in */  
									CRYS_DES_OperationMode_t  OperationMode,          /* in */     
									DxUint8_t                *DataIn_ptr,             /* in */ 
									DxUint32_t                DataInSize,             /* in */ 
									DxUint8_t                *ExpectedDataOut_ptr,        
									DxUint32_t                DataExpSize,
									int						  OutputLocation,
									char                     *FailureFunctionNameOut_ptr,        
									DxUint32_t                FuncNameMaxSize);
									
IMPORT_C DxUint32 SEPQA_DES_Integrated(
								CRYS_DES_Iv_t             IV_ptr,                 /* in */ 
									CRYS_DES_Key_t           *Key_ptr,                /* in */ 
									CRYS_DES_NumOfKeys_t      NumOfKeys,              /* in */ 
									CRYS_DES_EncryptMode_t    EncryptDecryptFlag,     /* in */  
									CRYS_DES_OperationMode_t  OperationMode,          /* in */     
									DxUint8_t                *DataIn_ptr,             /* in */ 
									DxUint32_t                DataInSize,             /* in */ 
									DxUint8_t                *ExpectedDataOut_ptr,        
									DxUint32_t                DataExpSize,
									int						  OutputLocation,
									char                     *FailureFunctionNameOut_ptr,        
									DxUint32_t                FuncNameMaxSize);   									
									
									
									
  

#ifdef __cplusplus
}
#endif

#endif  /* CRYS_HOST_TST_DES */
